/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class FileUtil {
    public static final int ORDER_DONT_CARE = 0;
    public static final int ORDER_BY_MODIFIED_TIME = 1;
    public static final int ORDER_BY_SIZE = 2;

    public static void copyFile(String string, String string2) throws IOException {
        File file = new File(string2);
        FileUtil.ensureDirExistsForFile(file);
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n != -1) {
            int n2 = bufferedInputStream.available();
            if (n2 > 1024) {
                n2 = 1024;
            }
            if (n2 == 0) {
                n = bufferedInputStream.read();
                if (n == -1) continue;
                bufferedOutputStream.write(n);
                continue;
            }
            n = bufferedInputStream.read(byArray, 0, n2);
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        byte[] byArray = new byte[4096];
        while ((n = bufferedInputStream.read(byArray, 0, 4096)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
        while ((n = bufferedInputStream.read()) != -1) {
            bufferedOutputStream.write(n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static File ensureDirExists(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File ensureDirExistsForFile(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file;
    }

    public static String removeDots(String string) {
        while (string.startsWith("..")) {
            string = string.substring(3);
        }
        return string;
    }

    public static String removeDirectories(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = n + 1 == string.length() ? "" : string.substring(n + 1);
        }
        return string;
    }

    public static byte[] readFileInBytes(String string) throws IOException {
        return FileUtil.readFileInBytes(new File(string));
    }

    public static byte[] readFileInBytes(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(fileInputStream.available());
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray, 0, 4096)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static StringBuffer readFile(String string) throws IOException {
        return FileUtil.readFile(new File(string));
    }

    public static StringBuffer readFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        return FileUtil.readFile(inputStreamReader);
    }

    public static StringBuffer readFile(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray, 0, 4096)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        reader.close();
        return stringBuffer;
    }

    public static void writeFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        bufferedWriter.write(string);
        bufferedWriter.close();
        outputStreamWriter.close();
        fileOutputStream.close();
    }
}

